import time, math

class Tests(object):
    def __init__(*argtuple):
        self = argtuple[0]
        testtype = argtuple[1]
        self.startTime = argtuple[2]

        self.CreepMaxPwm = 200  ## CONFIG
        self.CreepMinPwm = 2	## CONFIG

        self.SRLMaxPwm = 100	## CONFIG
        self.SRLMinPwm = 2		## CONFIG

        self.dynamicMaxPwm = 500	## CONFIG
        self.dynamicMinPwm = 2		## CONFIG
            
            
        self.SRLlookAhead = .5		## CONFIG
            
        self.testFlag = 0
        self.currentFreqs = 0
        self.currentFreqsTime = 0
        self.smallFreqLookAhead = 0.1   ## CONFIG
        self.lookAhead = .05  ## CONFIG
        self.stepsPerInch = 8000  ## CONFIG
        self.stepsPerMM= self.stepsPerInch/25.4

        self.beginFreqsTime = time.time()

		## based on the test type the handler knows what variables to expect and where

        if testtype == 'Creep Test':
            self.maxLoad = argtuple[3]
            self.runTime = argtuple[4]
            self.loadTime = argtuple[5]
            self.maxPWM = self.CreepMaxPwm
            self.minPWM = self.CreepMinPwm 
            self.creepCount = 0
            self.initialLoad = 0

            
        elif testtype == 'SRL Test': #test, numbersteps, peaktime, runtime
            self.samplethickness= argtuple[3]
            self.samplediam = argtuple[4]
            self.strainincr = argtuple[5]
            self.levels= argtuple[6]
            self.stepTime = argtuple[7]
            self.runtime = argtuple[8]

            self.maxPWM = self.SRLMaxPwm
            self.minPWM = self.SRLMinPwm

            #self.logint = open('logInt.txt', 'w')
            #self.logint.write('self.samplethickness= argtuple[3]' +'\t'+ 'self.samplediam = argtuple[4]'  +'\t'+  'self.strainincr = argtuple[5]'  +'\t'+ 'self.levels = argtuple[6]'  +'\t'+ 'self.stepTime = argtuple[7]'  +'\t'+ 'self.runtime = argtuple[8]'+ '\n')
            #print 'self.samplethickness= argtuple[3]'
          ##self.strWrite = str(self.samplethickness)+ '\t'+ str(self.samplediam )+ '\t' + str(self.strainincr)+ '\t'+ str(self.levels)+'\t'+str(self.stepTime)+'\t'+str(self.runtime) + '\n'
            #self.logint.write(str(self.samplethickness)+'\t'+str(self.samplediam)+'\t'+str(self.strainincr)+'\t'+ str(self.levels)+'\t'+ str(self.stepTime)+'\t'+str(self.runtime)+'\n')


            #print 'self.samplediam = argtuple[4]'
            #print  self.samplediam 
           # print 'self.strainincr = argtuple[5]'
           # print self.strainincr
           # print 'self.levels = argtuple[6]'
           # print self.levels
           # print 'self.stepTime = argtuple[7]'
          #  print self.stepTime
          #  print 'self.runtime = argtuple[8]'
          #  print self.runtime

            self.stepAmount = self.samplethickness * (self.strainincr / 100)
           # print 'step amount:' + str(self.stepAmount)
            self.currentTimeOnPeak = 0
            self.steps = []
            self.currentStep = 0
            self.loadReached = 0
            self.newPosReached = False
            self.overCount =0
           # print 'initialize SRL test'
          #  print 'step array formation'
            for i in range(1, int(self.levels)+1):
                self.steps += [self.stepAmount * i]
              #  print 'step array value: ' + str(self.stepAmount * i)
           # self.logint.write(str(self.steps)+ '\n')

        elif testtype == 'Dynamic Test': 
            self.testfreqs = argtuple[3]
            print 'initialized freqs' + str(self.testfreqs)
            self.cycles = argtuple[4]
            self.samplethickness= argtuple[5]
            
        elif testtype == 'Combined Test': 
		## yes its like the three tests copied and pasted

##self.test = TestHandling.Tests(self.testType, self.intitime, load, creepRuntime, self.loadtime, samplethickness, samplediam, strainincr, numbersteps, peaktime, srlRuntime, testfreqs, cycles)
            self.maxLoad = argtuple[3]
            self.runTime = argtuple[4]
            self.loadTime = argtuple[5]

            self.samplethickness= argtuple[6]
            self.samplediam = argtuple[7]
            self.strainincr = argtuple[8]
            self.levels= argtuple[9]
            self.stepTime = argtuple[10]
            self.runtime = argtuple[11]

            self.testfreqs = argtuple[12]
            self.cycles = argtuple[13]



            self.maxPWM =  self.dynamicMaxPwm
            self.minPWM =  self.dynamicMinPwm   
        
            self.creepCount = 0
            self.initialLoad = 0

            self.stepAmount = self.samplethickness * (self.strainincr / 100)
            self.currentTimeOnPeak = 0
            self.steps = []
            self.currentStep = 0
            self.loadReached = 0
            self.newPosReached = False
            self.overCount =0
         
            for i in range(1, int(self.levels)+1):
                self.steps += [self.stepAmount * i]             
           
    def resetTime(self, PassedTime):
        self.startTime = time.time()
        self.beginFreqsTime = time.time()
        
    def setPwm(self,testType):
        self.maxPWM = maxPWM
        self.minPWM = minPWM

    def updateSampleThickness(self, thickness) :
        self.samplethickness = thickness
        self.stepAmount = self.samplethickness * (self.strainincr / 100)
        self.currentTimeOnPeak = 0
        self.steps = []
        self.currentStep = 0
        self.loadReached = 0
        self.newPosReached = False
        self.overCount =0
        for i in range(1, int(self.levels)+1):
            self.steps += [self.stepAmount * i]
        
                            

    def SRLTest(self, currentload, currentpos, startpos, log):

        currentTime = time.time() - self.startTime 
        testComplete = False
        desiredPosition = self.steps[self.currentStep]+startpos
        pwmSpeed=100
        motorDirection = 'out'

		###### OLD TESTED CODE
		
		
        # if currentpos < desiredPosition:
            # motorDirection = 'out'
            # error = math.fabs(desiredPosition-currentpos)/self.stepAmount
            # sizecorrection = self.samplethickness/10
            # pwmSpeed = math.pow(error,.125)*(self.SRLMaxPwm - self.SRLMinPwm)*sizecorrection
            # if pwmSpeed < self.SRLMinPwm:
                # pwmSpeed = self.SRLMinPwm
		######		
				
		###### NEW DANGEROUS SEXY CODE
		
        if currentpos < desiredPosition:
            motorDirection = 'out'
            error = math.fabs(desiredPosition-currentpos)

            pwmSpeed = math.fabs(error*self.stepsPerMM / self.SRLlookAhead)
            if pwmSpeed < self.SRLMinPwm:
                pwmSpeed = self.SRLMinPwm				
				
		
		######
		

        elif currentpos >= desiredPosition:
            #motorDirection = 'in'
            motorDirection = 'none'
            self.overCount +=1
            if self.overCount == 1:
                self.newPosReached= True
                self.peakTimer = currentTime
            if currentTime - self.peakTimer > self.stepTime:
                self.currentStep +=1 
                self.overCount = 0
            if self.currentStep >= self.levels:
                testComplete = True

        if currentTime> (self.levels * self.stepTime)+(2*self.levels):
            testComplete = True
      
        return motorDirection, pwmSpeed, testComplete
            
        
        

        
    def CreepTest(self, currentLoad): #maintains load
        if self.creepCount == 0:
            self.initialLoad = currentLoad[1]

        self.creepCount += 1


        testComplete = False
        currentTime = time.time() - self.startTime #time into test
       # print 'test time'
      #  print currentTime, self.runTime
        
        load = (self.maxLoad/self.loadTime)*currentTime
        if load >= self.maxLoad:
            load = self.maxLoad
      #  print 'desired load:' + str(load)

        error = math.fabs(load-currentLoad[1])/load
        pwmSpeed = error*(math.fabs(self.CreepMaxPwm-self.CreepMinPwm))

        if pwmSpeed < self.CreepMinPwm:
            pwmSpeed = self.CreepMinPwm
        
        if currentTime >= self.runTime:
            return 1, 1, 'none', True
        else:
            if currentLoad[1] ==load:
                directionToMove = 'none'
            elif currentLoad[1] < load:
                directionToMove = 'out'  
            elif currentLoad[1] > load:
                directionToMove = 'in'
  

            
            timeToRun = .05
        #    print 'action decided:' + directionToMove


        return pwmSpeed, timeToRun, directionToMove, testComplete
    
 
                



        
        
    def DynamicTest(self, currentload, currentpos, startpos, log):

        testComplete = False        
        pwmSpeed=400
        motorDirection = 'out'
##        fixDirection = 'out'
##        fixValue = 0
        #fixDirectionEnable = False

        currentTime = time.time() - self.startTime 
        self.currentFreqsTime = time.time()-self.beginFreqsTime
       # print 'current FreqsTime' + str(self.currentFreqsTime)
        frequency = (self.testfreqs[self.currentFreqs])[0]
        print 'frequency' + str(self.testfreqs)
        strain = (self.testfreqs[self.currentFreqs])[1]
        strainAmplitude = strain*.01*self.samplethickness


		##Stuff is commented out because it was replaced by better code
		
      #  print 'strain amp' + str(strainAmplitude)
      #  print 'startpos' + str(startpos)
       # print 'desired pos ' + str(desiredPosition)
##        fixValue = -math.cos(self.currentFreqsTime*frequency*2*math.pi)
##        if fixValue < 0:
##            fixDirection = 'in'
##            #print 'fix in' + str(fixValue)
##        if fixValue >= 0:
##            fixDirection = 'out'
##            #print 'fix out' + str(fixValue)
####        if frequency >=1:
####        fixDirectionEnable = True


        desiredPosition = -.5*strainAmplitude*math.sin(self.currentFreqsTime*frequency*2*math.pi)        
        desiredPosition = desiredPosition + startpos


        
        
##          May be needed to adjust for 1hz being very difficult for the motor to do
        if frequency > .5:
            self.smallFreqLookAhead = .1
        else:
            pass
        


        #error = math.fabs(desiredPosition-currentpos)

            #This works by figuring out where it needs to be in the future and figuring out what pwm step rate
            # will get it to that position
        desiredPositionInTheFuture = -.5*strainAmplitude*math.sin((self.currentFreqsTime+self.lookAhead)*frequency*2*math.pi)
        desiredPositionInTheFuture = desiredPositionInTheFuture + startpos
        changePos = desiredPositionInTheFuture - currentpos
        pwmSpeed = math.fabs(changePos*self.stepsPerMM / self.lookAhead)
        #print 'pwm speed ' + str(pwmSpeed)
        

        
##        sizecorrection = self.samplethickness/10
##        pwmSpeed = math.pow(error,.125)*(self.dynamicMaxPwm - self.dynamicMinPwm)#*sizecorrection
        
        if pwmSpeed < self.dynamicMinPwm:
            motorDirection = 'none'
   
        if self.currentFreqsTime > (self.cycles * (1/ frequency)):
            self.currentFreqs +=1
            self.beginFreqsTime = time.time()
            if self.currentFreqs>len(self.testfreqs)-1:
                testComplete = True

						##Stuff is commented out because it was replaced by better code
				
##        if fixDirectionEnable == True:
##            if currentpos < desiredPosition and fixDirection == 'out':
##                motorDirection = 'out'
##               # print motorDirection
##            elif currentpos >= desiredPosition and fixDirection == 'in':
##                motorDirection = 'in'
##              #  print motorDirection
##            else:
##              #  print 'no match desired and fix'
##                motorDirection = 'none'
##        else:
                
        if changePos>= 0:
            motorDirection = 'out'
            #print motorDirection
        elif changePos <0:
            motorDirection = 'in'
            #print motorDirection
        else:
            'well, crap'

        return motorDirection, pwmSpeed, testComplete
        
