import time
from PythonCard import configuration, dialog, model, timer
import wx, ConfigParser
from scipy import stats

class CalibrationClass(model.Background):
    
    def on_initialize(self, event):
        self.parent = self.getParent()

        ## timer controls refresh of position or load in the GUI
        self.dataTimer = timer.Timer(self.components.currentVoltage, -1)
        self.voltage = []
        self.lvdtpos = []
        self.voltmm = 0.0
        self.selectedData = object
        self.data ={}
        self.datapoints =0

        ## add labels to the beginning of the data list
        self.components.DataList.InsertColumn(0, "Position")
        self.components.DataList.InsertColumn(1, "Voltage")
        
    def on_close(self, event):
        self.dataTimer.Stop()
        self.parent.datahan.update_voltmm(self.voltmm)
        self.parent.voltmm = self.voltmm
        result = dialog.messageDialog(self, 'Save the new LVDT constant to settings?', 'Warning',wx.ICON_EXCLAMATION | wx.YES_NO)
        if result.returnedString == 'Yes':
            self.parent.settingsWindow.components.MMVoltInput.text = str(self.voltmm)  #This goes back
            #into the parent window, mechtest, and tells it to save the value to the settings.
            self.parent.settingsWindow.on_menuFileSave_select(event)
        self.visible = False

    def on_exit_command(self, event):
        self.close()
        
    def on_currentVoltage_timer(self, event):
        #print 'timer'
        #takes 5 samples so that an average is used
        datas = self.parent.datahan.analogin.acquire(5)[5:]
        (a,b,r,tt,stderr) = stats.linregress(self.voltage, self.lvdtpos)  #make a linear regression
            ##through the given data points.  The slope is the LVDT contstant
        self.voltmm = a
        lvdt = sum(datas)/5.0 #this does the averaging
        position = lvdt * self.voltmm
        self.components.currentVoltage.text = 'Current Voltage: %.5f' %lvdt
        self.components.estimatedPosition.text = 'Estimated Position: %.5f' %position
        self.components.mmvConstant.text = 'mm/V Constant: %.5f' %self.voltmm
        
    def initializetime(self):
        self.dataTimer.Start(50)
    ####################################
    ######      Menu Actions      ######
    ####################################

    ################   
    ##### File #####
    ################
    def on_menuFileExit_select(self, event):
        self.close()
        
    ######################################
    ######      Button Actions      ######
    ######################################
    def on_addDataPoint_mouseClick(self, event):

        #this does the actual collection and figuring of the LVDT constant.
        
        position = self.components.CurrentPositionInput.text  # user enters a position
        goodtogo = True
        for char in  position:
            if char not in '.0123456789':  #check to make sure valid character
                goodtogo = False
        if goodtogo == True:
            print 'add data point'
            self.datapoints += 1
            self.lvdtpos.append(-float(position))  #why the - I'm not sure but it has to do with the
            #   positive direction of the LVDT is downwards but the motors positive is upwards.
            #   Or something like that.  It works.
            datas = self.parent.datahan.analogin.acquire(5)[5:] #average 5 pts
            voltage = sum(datas)/5.0
            self.voltage.append(voltage) #add the voltage to the voltage array
            (a,b,r,tt,stderr) = stats.linregress(self.voltage, self.lvdtpos)#pass the linregresss X and Y points
            self.voltmm = a  #slope is the constant
            self.updateDataList()  # update the list of points in the GUI
        else:
            dialog.messageDialog(self, 'Invalid Position Entry', 'Warning',wx.ICON_EXCLAMATION | wx.OK | wx.CANCEL)
                
    def updateDataList(self):

         # update the list of points in the GUI every time a new point is added
        # since a point can be removed this starts from scratch every time it is run
        self.components.DataList.DeleteAllItems()
        for i in range(self.datapoints):
            self.components.DataList.InsertStringItem(i, str(i))
            self.components.DataList.SetStringItem(i, 0, str(self.lvdtpos[i]))
            self.components.DataList.SetStringItem(i, 1, str(self.voltage[i]))
            self.components.DataList.SetItemData(i, int(i))
            self.data ={int(i):(str(self.lvdtpos[i]), str(self.voltage[i]))}
            self.components.DataList.SetItemDataMap(self.data)  #This is a bunch of dictionary based python I don't know

    def on_DeleteData_mouseClick(self, event):
        #deletes data point from list
        self.datapoints -= 1
        self.voltage.remove(self.voltage[self.selectedData])
        self.lvdtpos.remove(self.lvdtpos[self.selectedData])
        self.updateDataList()

    def on_DataList_select(self, event):
        #focuses to a selected data point that can then be deleted
        self.selectedData = event.m_itemIndex
        
    def on_MotorSpeedSlider_select(self, event):
        #changes the rate of the motor jog so that different positions can be used
        self.parent.motfrequency =  int(self.components.MotorSpeedSlider.value)
        print 'motor freq set to:' + str(self.parent.motfrequency)
        
    def on_moveDown_mouseClick(self, event):
        #This is the move down routine from the main mech test file look there for comments
        if self.parent.currentDaq == 99999:
            result = dialog.messageDialog(self, 'Please select a Daq first', 'Warning',wx.ICON_EXCLAMATION | wx.OK | wx.CANCEL)
            if result.returnedString == 'Ok':
                self.parent.on_menuDaqFinding_select(event)
        else:
            self.parent.currentdir = 0
            self.parent.motorhand.creep_begin()
            self.parent.motorhand.coarse_step(self.parent.motfrequency, self.parent.currentdir)
            initialTime = time.time()
            while self.parent.CheckCriticalSensors() and time.time() - initialTime < .3:
                pass
            self.parent.motorhand.creep_end()
         
    def on_moveUp_mouseClick(self, event):

        #This is the move up routine from the main mech test file look there for comments
        if self.parent.currentDaq == 99999:
            result = dialog.messageDialog(self, 'Please select a Daq first', 'Warning',wx.ICON_EXCLAMATION | wx.OK | wx.CANCEL)
            if result.returnedString == 'Ok':
                self.parent.on_menuDaqFinding_select(event)
        else:
            self.parent.currentdir = 1
            self.parent.motorhand.creep_begin()
            self.parent.motorhand.coarse_step(self.parent.motfrequency, self.parent.currentdir)
            initialTime = time.time()
            while self.parent.CheckCriticalSensors() and time.time() - initialTime < .3:
                pass
            self.parent.motorhand.creep_end()
            
if __name__ == '__main__':
    app = model.Application(MyBackground)
    app.MainLoop()
