import os, sys, wx, pydaqtools as pdt
from pydaqtools import daq, find_daqs
from PythonCard import configuration, dialog, model
import DataHandling, MotorHandling
####################################################################
###########      This file is the daq finding window that ##########
###########      detects and connects to a DAQ            ##########


class FindDaqClass(model.Background):
    
    def on_initialize(self, event):
        ### Prepares the window and creates the nice table
        self.gainFocus = True
        self.parent = self.getParent()
        self.components.DaqList.InsertColumn(0, "DAQid")
        self.components.DaqList.InsertColumn(1, "Bus")
        self.components.DaqList.InsertColumn(2, "Handle")
        self.components.DaqList.InsertColumn(3, "Model")
        
    def on_close(self, event):
        self.visible = False
        if self.parent.currentDaq != 99999:  #if a valid daq found
            #initalize bottom status bar
            self.parent.statbar.SetStatusText('DaqID: ' + str(self.parent.currentDaq) + '      Settings File: ' + self.parent.settingsfile + '      Parameter File: ' + self.parent.paramfile)
##            print 'initialize thred'
##            self.parent.initializeThread()
            print 'initialize timer'
            
            ## this timer controls the updates to the information in the GUI like current load and position
            self.parent.initializeTimer()
            
    def on_exit_command(self, event):
        self.close()
       
 
    ####################################
    ######      Menu Actions      ######
    ####################################

    ################   
    ##### File #####
    ################
    def on_menuFileExit_select(self, event):
        self.close()
        
    ################   
    ##### Edit #####
    ################
    def on_menuEditUndo_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canUndo():
            widget.undo()

    def on_menuEditRedo_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canRedo():
            widget.redo()

    def on_menuEditCut_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canCut():
            widget.cut()

    def on_menuEditCopy_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canCopy():
            widget.copy()

    def on_menuEditPaste_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canPaste():
            widget.paste()
        
    def on_menuEditClear_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable'):
            if widget.canCut():
                # delete the current selection,
                # if we can't do a Cut we shouldn't be able to delete either
                # which is why i used the test above
                sel = widget.replaceSelection('')
            else:
                ins = widget.getInsertionPoint()
                try:
                    widget.replace(ins, ins + 1, '')
                except:
                    pass

    def on_menuEditSelectAll_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable'):
            widget.setSelection(0, widget.getLastPosition())

    ##################################
    ######      Daq Update      ######
    ##################################
    def on_connectToDaq_command(self,event):
        if self.parent.currentDaq == 99999:
            dialog.messageDialog(self, 'Failed to connect to Daq', 'Failed to connect to Daq',wx.ICON_HAND | wx.CANCEL)
        else:
            try:
                self.parent.motorhand = MotorHandling.Motor(self.parent.currentDaq, self.parent.motchannel, self.parent.digchannel, self.parent.cochannel)
                self.parent.datahan =  DataHandling.Data(self.parent.currentDaq, self.parent.anchannel, self.parent.samprate, self.parent.gramvolt, self.parent.voltmm)
                self.parent.motorhand.enable_motor() #sets enable bit of motor driver
                dialog.messageDialog(self, 'Connected to Daq', 'Connected to Daq',wx.ICON_EXCLAMATION | wx.OK)    
            except:
                dialog.messageDialog(self, 'Failed to connect to Daq', 'Failed to connect to Daq',wx.ICON_HAND | wx.CANCEL)
                
    def on_daqhwinfo_command(self,event):
        if self.parent.currentDaq == 99999:
            self.daqlog = 'Please Select a valid Daq'
        else:
            alldaqs = find_daqs.get_classes()
            daqid = self.parent.currentDaq


            ## adds info to  table
            self.daqlog = 'daqid:\t' + str(alldaqs[daqid].id) + '\n'
            self.daqlog =  self.daqlog + 'Bus:\t' + str(alldaqs[daqid].bus) + '\n'
            self.daqlog =  self.daqlog + 'Handle:\t' + str(alldaqs[daqid].handle) + '\n'
            if(alldaqs[daqid].simulated):
                self.daqlog =  self.daqlog +  'DAQ is simulated\n'
            self.daqlog =  self.daqlog + 'Model:\t' + str(alldaqs[daqid].model) + '\n'
            if(alldaqs[daqid].category):
                self.daqlog =  self.daqlog + 'Category:\t' + str(alldaqs[daqid].category) + '\n'
            if(alldaqs[daqid].serial_number):
                self.daqlog =  self.daqlog +  'Serial Number:\t' + str(alldaqs[daqid].serial_number) + '\n'  

            self.daqlog =  self.daqlog +   '\nNumber of Pins:\n'
            self.daqlog =  self.daqlog +   'daqid  aIn    aOut   dIn    dOut   cntIn  cntOut\n'
            #alldaqs[daqid]['id'] = daqid
            self.daqlog =  self.daqlog +   '   %-8s%-9s%-9s%-9s%-9s%-10s%-10s\n'% (alldaqs[daqid].id,
                                                   alldaqs[daqid].numai,
                                                   alldaqs[daqid].numao,
                                                   alldaqs[daqid].numdi,
                                                   alldaqs[daqid].numdo,
                                                   alldaqs[daqid].numci,
                                                   alldaqs[daqid].numco)

            if(alldaqs[daqid].atrigger):
                self.daqlog =  self.daqlog + '\nAnalog Trigger Supported\n'
            if(alldaqs[daqid].dtrigger):
                self.daqlog =  self.daqlog + '\nDigital Trigger Supported\n'
            if(alldaqs[daqid].aichannels):
                self.daqlog =  self.daqlog + '\nAnalog Input Channels:\n'
                self.daqlog =  self.daqlog+ str(alldaqs[daqid].aichannels) + '\n'
            if(alldaqs[daqid].maxSchRate):
                self.daqlog =  self.daqlog + '\nMaximum Single Channel Sample Rate:' + str(alldaqs[daqid].maxSchRate) + '\n'
            if(alldaqs[daqid].maxMchRate):
                self.daqlog =  self.daqlog + '\nMaximum Muliple Channel Sample Rate:' + str(alldaqs[daqid].maxMchRate) + '\n'
            if(alldaqs[daqid].minSamplingRate):
                self.daqlog =  self.daqlog + '\nMinimum Sample Rate:' + str(alldaqs[daqid].minSamplingRate) + '\n'
            if(alldaqs[daqid].simSampling):
                self.daqlog =  self.daqlog + '\nSimultaneous Sampling Supported\n'
            if(alldaqs[daqid].aochannels):
                self.daqlog =  self.daqlog + '\nAnalog Output Channels:\n'
                self.daqlog =  self.daqlog + str(alldaqs[daqid].aochannels) + '\n' 
            if(alldaqs[daqid].dils):
                self.daqlog =  self.daqlog + '\nDigital Input Lines Channels:\n'
                self.daqlog =  self.daqlog + str(alldaqs[daqid].dils) + '\n'
            if(alldaqs[daqid].dips):
                self.daqlog =  self.daqlog + '\nDigital Input Ports:\n'
                self.daqlog =  self.daqlog + str(alldaqs[daqid].dips) + '\n'
            if(alldaqs[daqid].dols):
                self.daqlog =  self.daqlog + '\nDigital Output Lines:\n'
                self.daqlog =  self.daqlog + str(alldaqs[daqid].dols) + '\n'
            if(alldaqs[daqid].dops):
                self.daqlog =  self.daqlog + '\nDigital Output Ports:\n'
                self.daqlog =  self.daqlog + str(alldaqs[daqid].dops) + '\n'
            if(alldaqs[daqid].cichannels):
                self.daqlog =  self.daqlog + '\nCounter Input Channels:\n'
                self.daqlog =  self.daqlog + str(alldaqs[daqid].cichannels) + '\n' 
            if(alldaqs[daqid].cochannels):
                self.daqlog =  self.daqlog + '\nCounter Output Channels:\n'
                self.daqlog =  self.daqlog + str(alldaqs[daqid].cochannels) + '\n'  
        self.components.DaqDisplay.text = self.daqlog
            
    def on_daqfind_command(self,event):
        self.components.DaqList.DeleteAllItems()
        find_daqs.create_classes()
        alldaqs = find_daqs.get_classes()
        nd = len(alldaqs)
        daqlist = {}
        for i in range(0,nd):
            self.components.DaqList.InsertStringItem(i, str(alldaqs[i].id))
            self.components.DaqList.SetStringItem(i, 0, str(alldaqs[i].id))
            self.components.DaqList.SetStringItem(i, 1, str(alldaqs[i].bus))
            self.components.DaqList.SetStringItem(i, 2, str(alldaqs[i].handle,))
            self.components.DaqList.SetStringItem(i, 3, str(alldaqs[i].model))
            self.components.DaqList.SetItemData(i, int(alldaqs[i].id))
            daqlist = {int(alldaqs[i].id):(str(alldaqs[i].id), str(alldaqs[i].bus), str(alldaqs[i].handle), str(alldaqs[i].model))}
        self.components.DaqList.SetItemDataMap(daqlist)

        self.components.DaqList.SetColumnWidth(0, 60)
        self.components.DaqList.SetColumnWidth(1, 50)
        self.components.DaqList.SetColumnWidth(2, 55)
        self.components.DaqList.SetColumnWidth(3, 100)

    def on_DaqList_select(self, event):
        self.parent.currentDaq = event.m_itemIndex
        
if __name__ == '__main__':
    app = model.Application(MyBackground)
    app.MainLoop()
