from PythonCard import configuration, dialog, model
import ConfigParser

## this handles the settings storage with a config parser


class SettingsClass(model.Background):
    
    def on_initialize(self, event):
        self.filepath = ''
        self.parent = self.getParent()
    
    def on_close(self, event):
        if self.filepath != '':
            self.parent.settingspath = self.filepath
            self.parent.settingsfile = (self.filepath.split('\\')).pop()
            self.parent.statbar.SetStatusText('DaqID: ' + str(self.parent.currentDaq) + '      Settings File: ' + self.parent.settingsfile + '      Parameter File: ' + self.parent.paramfile)
            self.parent.samprate = int(self.components.SampleRateInput.text)        #rate to burst sample
            self.parent.sampwait = 1.0/self.parent.samprate
            self.parent.sampnum = int(self.components.NumberSampleInput.text)        #samples to read in
            self.parent.cochannel = int(self.components.StepInput.text)      #stepwave
            self.parent.anchannel = [int(self.components.LoadCellInput.text),int(self.components.LVDTInput.text)]     #[loadcell,lvdt]
            self.parent.motchannel = [int(self.components.DirecInput.text),int(self.components.StepInput.text),int(self.components.DisableInput.text)]    #[direction,step,disable]
            self.parent.digchannel = [int(self.components.FrontLimInput.text),int(self.components.RearLimInput.text)]    #[frontlim,backlim]
            self.parent.maxload = float(self.components.LoadCellGram.text)        #max load ammount
            self.parent.gramvolt = float(self.components.GramVoltInput.text)       #load cell rating
            self.parent.voltmm = float(self.components.MMVoltInput.text)         #conversion volt to mm, calibration tool
        self.visible = False

    def updateAdvancedOptions(self):
        self.parent.SRLPwmUpdateQty = int(self.components.SRLPwmUpdateQtyInput.text)
        self.parent.creepPwmUpdateQty = int(self.components.creepPwmUpdateQtyInput.text)
        self.parent.test.CreepMaxPwm = int(self.components.CreepMaxPwmInput.text)
        self.parent.test.CreepMinPwm = int(self.components.CreepMinPwmInput.text)
        self.parent.test.SRLMaxPwm = int(self.components.SRLMaxPwmInput.text)
        self.parent.test.SRLMinPwm = int(self.components.CreepMinPwmInput.text)
        self.parent.test.dynamicMaxPwm = int(self.components.dynamicMaxPwmInput.text)
        self.parent.test.dynamicMinPwm = int(self.components.dynamicMinPwmInput.text)
        self.parent.test.SRLlookAhead = float(self.components.SRLlookAheadInput.text)
        self.parent.test.smallFreqLookAhead = float(self.components.smallFreqLookAheadInput.text)
        self.parent.test.lookAhead = float(self.components.lookAheadInput.text)
        self.parent.test.stepsPerInch = int(self.components.stepsPerInchInput.text)


    def on_exit_command(self, event):
        self.close()
            
    ####################################
    ######      Menu Actions      ######
    ####################################

    ################   
    ##### File #####
    ################
    def on_menuFileExit_select(self, event):
        self.close()
        
    def on_menuFileOpen_select(self, event):
        config = ConfigParser.RawConfigParser()
        result = dialog.openFileDialog(directory=self.parent.components.FilePathInput.text,wildcard='Configuration Files (*.cfg)|*.cfg|All Files (*.*)|*.*')
        if result.accepted == True:
            self.filepath = str(result.paths[0])
            config.read(self.filepath)
            #channels
            self.components.LoadCellInput.text = config.get('Channels', 'LoadCellChan')
            self.components.LVDTInput.text = config.get('Channels', 'LVDTChan')
            self.components.StepInput.text = config.get('Channels', 'CounterChan')
            self.components.StepInput.text = config.get('Channels', 'StepChan')
            self.components.DisableInput.text = config.get('Channels', 'DisChan')
            self.components.DirecInput.text = config.get('Channels', 'DirecChan')
            self.components.FrontLimInput.text = config.get('Channels', 'FrntLimChan')
            self.components.RearLimInput.text = config.get('Channels', 'RearLimChan')
            #sampling
            self.components.SampleRateInput.text = config.get('Sampling', 'SampleRate')
            self.components.NumberSampleInput.text = config.get('Sampling', 'NumberSamples')
            self.components.LoadCellGram.text = config.get('Sampling', 'LoadCellRating')
            self.components.GramVoltInput.text = config.get('Sampling', 'gvconst')
            self.components.MMVoltInput.text = config.get('Sampling', 'mmvconst')
            #advanced
            self.components.SRLPwmUpdateQtyInput.text = config.get('Advanced', 'SRLPwmUpdateQtyInput')
            self.components.creepPwmUpdateQtyInput.text = config.get('Advanced', 'creepPwmUpdateQtyInput')
            self.components.CreepMaxPwmInput.text = config.get('Advanced', 'CreepMaxPwmInput')
            self.components.CreepMinPwmInput.text = config.get('Advanced', 'CreepMinPwmInput')
            self.components.SRLMaxPwmInput.text = config.get('Advanced', 'SRLMaxPwmInput')
            self.components.SRLMinPwmInput.text = config.get('Advanced', 'SRLMinPwmInput')
            self.components.dynamicMaxPwmInput.text = config.get('Advanced', 'dynamicMaxPwmInput')
            self.components.dynamicMinPwmInput.text = config.get('Advanced', 'dynamicMinPwmInput')
            self.components.SRLlookAheadInput.text = config.get('Advanced', 'SRLlookAheadInput')
            self.components.smallFreqLookAheadInput.text = config.get('Advanced', 'smallFreqLookAheadInput')
            self.components.lookAheadInput.text = config.get('Advanced', 'lookAheadInput')
            self.components.stepsPerInchInput.text = config.get('Advanced', 'stepsPerInchInput')
        self.visible= False
        self.visible= True
        
    def on_menuFileSave_select(self, event):
        config = ConfigParser.RawConfigParser()
        #channels
        config.add_section('Channels')
        config.set('Channels', 'LoadCellChan', self.components.LoadCellInput.text)
        config.set('Channels', 'LVDTChan', self.components.LVDTInput.text)
        config.set('Channels', 'CounterChan', self.components.StepInput.text)
        config.set('Channels', 'StepChan', self.components.StepInput.text)
        config.set('Channels', 'DisChan', self.components.DisableInput.text)
        config.set('Channels', 'DirecChan', self.components.DirecInput.text)
        config.set('Channels', 'FrntLimChan', self.components.FrontLimInput.text)
        config.set('Channels', 'RearLimChan', self.components.RearLimInput.text)
        #sampling
        config.add_section('Sampling')
        config.set('Sampling', 'SampleRate', self.components.SampleRateInput.text)
        config.set('Sampling', 'NumberSamples', self.components.NumberSampleInput.text)
        config.set('Sampling', 'LoadCellRating', self.components.LoadCellGram.text) 
        config.set('Sampling', 'gvconst', self.components.GramVoltInput.text)
        config.set('Sampling', 'mmvconst', self.components.MMVoltInput.text)
        #advaced
        config.add_section('Advanced')
        config.set('Advanced', 'SRLPwmUpdateQtyInput', self.components.SRLPwmUpdateQtyInput.text)
        config.set('Advanced', 'creepPwmUpdateQtyInput', self.components.creepPwmUpdateQtyInput.text)
        config.set('Advanced', 'CreepMaxPwmInput', self.components.CreepMaxPwmInput.text)
        config.set('Advanced', 'CreepMinPwmInput', self.components.CreepMinPwmInput.text)
        config.set('Advanced', 'SRLMaxPwmInput', self.components.SRLMaxPwmInput.text)
        config.set('Advanced', 'SRLMinPwmInput', self.components.SRLMinPwmInput.text)
        config.set('Advanced', 'dynamicMaxPwmInput', self.components.dynamicMaxPwmInput.text)
        config.set('Advanced', 'dynamicMinPwmInput', self.components.dynamicMinPwmInput.text)
        config.set('Advanced', 'SRLlookAheadInput', self.components.SRLlookAheadInput.text)
        config.set('Advanced', 'smallFreqLookAheadInput', self.components.smallFreqLookAheadInput.text)
        config.set('Advanced', 'lookAheadInput', self.components.lookAheadInput.text)
        config.set('Advanced', 'stepsPerInchInput', self.components.stepsPerInchInput.text)
        if self.filepath == '':
            result = dialog.saveFileDialog(filename='settings.cfg',directory=self.parent.components.FilePathInput.text,wildcard='Configuration Files (*.cfg)|*.cfg|All Files (*.*)|*.*')
            if result.accepted == True:
                self.filepath = str(result.paths[0])
                if (self.filepath)[len(self.filepath)-4:] == '.cfg':
                    stradd = ''
                else:
                    stradd = '.cfg'
                with open(self.filepath + stradd, 'wb') as configfile:
                     config.write(configfile)
        else:
            with open(self.filepath, 'wb') as configfile:
                     config.write(configfile)
                     configfile.close()
        self.visible= False
        self.visible= True

    def on_menuFileSaveAs_select(self, event):
        config = ConfigParser.RawConfigParser()
        #channels
        config.add_section('Channels')
        config.set('Channels', 'LoadCellChan', self.components.LoadCellInput.text)
        config.set('Channels', 'LVDTChan', self.components.LVDTInput.text)
        config.set('Channels', 'CounterChan', self.components.StepInput.text)
        config.set('Channels', 'StepChan', self.components.StepInput.text)
        config.set('Channels', 'DisChan', self.components.DisableInput.text)
        config.set('Channels', 'DirecChan', self.components.DirecInput.text)
        config.set('Channels', 'FrntLimChan', self.components.FrontLimInput.text)
        config.set('Channels', 'RearLimChan', self.components.RearLimInput.text)
        #sampling
        config.add_section('Sampling')
        config.set('Sampling', 'SampleRate', self.components.SampleRateInput.text)
        config.set('Sampling', 'NumberSamples', self.components.NumberSampleInput.text)
        config.set('Sampling', 'LoadCellRating', self.components.LoadCellGram.text) 
        config.set('Sampling', 'gvconst', self.components.GramVoltInput.text)
        config.set('Sampling', 'mmvconst', self.components.MMVoltInput.text)
        config.add_section('Advanced')
        config.set('Advanced', 'SRLPwmUpdateQtyInput', self.components.SRLPwmUpdateQtyInput.text)
        config.set('Advanced', 'creepPwmUpdateQtyInput', self.components.creepPwmUpdateQtyInput.text)
        config.set('Advanced', 'CreepMaxPwmInput', self.components.CreepMaxPwmInput.text)
        config.set('Advanced', 'CreepMinPwmInput', self.components.CreepMinPwmInput.text)
        config.set('Advanced', 'SRLMaxPwmInput', self.components.SRLMaxPwmInput.text)
        config.set('Advanced', 'SRLMinPwmInput', self.components.SRLMinPwmInput.text)
        config.set('Advanced', 'dynamicMaxPwmInput', self.components.dynamicMaxPwmInput.text)
        config.set('Advanced', 'dynamicMinPwmInput', self.components.dynamicMinPwmInput.text)
        config.set('Advanced', 'SRLlookAheadInput', self.components.SRLlookAheadInput.text)
        config.set('Advanced', 'smallFreqLookAheadInput', self.components.smallFreqLookAheadInput.text)
        config.set('Advanced', 'lookAheadInput', self.components.lookAheadInput.text)
        config.set('Advanced', 'stepsPerInchInput', self.components.stepsPerInchInput.text)
        result = dialog.saveFileDialog(directory=self.parent.components.FilePathInput.text,wildcard='Configuration Files (*.cfg)|*.cfg|All Files (*.*)|*.*')
        if result.accepted == True:
            self.filepath = str(result.paths[0])
            if (self.filepath)[len(self.filepath)-4:] == '.cfg':
                stradd = ''
            else:
                stradd = '.cfg'
            with open(self.filepath + stradd, 'wb') as configfile:
                config.write(configfile)
                configfile.close()
        self.visible= False
        self.visible= True

    ################   
    ##### Edit #####
    ################
    def on_menuEditUndo_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canUndo():
            widget.undo()

    def on_menuEditRedo_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canRedo():
            widget.redo()

    def on_menuEditCut_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canCut():
            widget.cut()

    def on_menuEditCopy_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canCopy():
            widget.copy()

    def on_menuEditPaste_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canPaste():
            widget.paste()
        
    def on_menuEditClear_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable'):
            if widget.canCut():
                # delete the current selection,
                # if we can't do a Cut we shouldn't be able to delete either
                # which is why i used the test above
                sel = widget.replaceSelection('')
            else:
                ins = widget.getInsertionPoint()
                try:
                    widget.replace(ins, ins + 1, '')
                except:
                    pass

    def on_menuEditSelectAll_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable'):
            widget.setSelection(0, widget.getLastPosition())

if __name__ == '__main__':
    app = model.Application(MyBackground)
    app.MainLoop()
