import wx, math, numpy
from PythonCard import configuration, dialog, model

class SaveClass(model.Background):
    
    def on_initialize(self, event):
        self.filepath = ''
        self.gainFocus = True
        self.parent = self.getParent()
        self.updateFileName()
    
    def on_close(self, event):
        self.parent.components.FilePathInput.text = (str(self.components.FilePath.text))[11:]
        self.visible = False

    def on_exit_command(self, event):
        self.close()
        
##    def on_idle(self,event):
##        self.updateFileName()
       
 
    ####################################
    ######      Menu Actions      ######
    ####################################

    ################   
    ##### File #####
    ################
    def on_menuFileExit_select(self, event):
        self.close()
        
    ################   
    ##### Edit #####
    ################
    def on_menuEditUndo_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canUndo():
            widget.undo()

    def on_menuEditRedo_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canRedo():
            widget.redo()

    def on_menuEditCut_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canCut():
            widget.cut()

    def on_menuEditCopy_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canCopy():
            widget.copy()

    def on_menuEditPaste_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable') and widget.canPaste():
            widget.paste()
        
    def on_menuEditClear_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable'):
            if widget.canCut():
                # delete the current selection,
                # if we can't do a Cut we shouldn't be able to delete either
                # which is why i used the test above
                sel = widget.replaceSelection('')
            else:
                ins = widget.getInsertionPoint()
                try:
                    widget.replace(ins, ins + 1, '')
                except:
                    pass

    def on_menuEditSelectAll_select(self, event):
        widget = self.findFocus()
        if hasattr(widget, 'editable'):
            widget.setSelection(0, widget.getLastPosition())

    ########################################
    ######      File Name Update      ######
    ########################################
    def on_ExpName_textUpdate(self,event):
        self.updateFileName()
        
    def on_ProjName_textUpdate(self,event):
        self.updateFileName()
        
    def on_TestDayInput_textUpdate(self,event):
        self.updateFileName()
        
    def on_SampleNumberInput_textUpdate(self,event):
        self.updateFileName()
        
    def updateFileName(self):
        projectname = self.components.ProjName.text
        expername = self.components.ExpName.text
        testday = self.components.TestDayInput.text
        samplenum = self.components.SampleNumberInput.text
        self.components.SimpleName.text = projectname + '-' + expername + '-Day' + testday + '-Sample' + samplenum + '.csv'
    ###################################
    #######     Saving Data     #######
    ###################################
    def update_path(self, path):
        self.components.FilePath.text = 'File Path: ' + path
        
    def on_changeFilePath_mouseClick(self, event):
        result = dialog.directoryDialog(self, 'Choose a directory', '')
        if result.accepted == True:
            self.components.FilePath.text = 'File Path: ' + str(result.path)

    def on_CloseButton_mouseClick(self, event):
        self.close()

    def on_saveData_mouseClick(self,event):
        ### have to add testtype variable to identify which test is run
        if self.parent.datatosave == True and self.parent.maindata != []:
            if str(self.components.SimpleName.text)[len(str(self.components.SimpleName.text))-4:] != '.csv':
                self.components.SimpleName.text = str(self.components.SimpleName.text) + '.csv'
            #savefile = (str(self.components.FilePath.text).split(' '))[2] + '\\' + str(self.components.SimpleName.text)
            savefile = (str(self.components.FilePath.text))[11:] + '\\' + str(self.components.SimpleName.text)
            savestring = [['Project Name',self.components.ProjName.text],
                          ['Group Name',self.components.ExpName.text],
                          ['Test Day',self.components.TestDayInput.text],
                          ['Sample Number',self.components.SampleNumberInput.text],
                          ['Test Type',self.parent.testType],
                          [''],
                          ['Notes',self.parent.components.NoteInput.text],
                          ['']]
            if self.parent.testType == 'Creep Test':
                savestring += [['Test Parameters','Load Limit (g)','Test Run Time (s)'],
                               ['',self.parent.components.LoadLimInput.text,self.parent.components.TimeRunInput.text],
                               ['']]
            elif self.parent.testType == 'SRL Test':
                savestring += [['Test Parameters','Thickness (mm)','Diameter (mm)','Strain Incraments (%)','Number of Steps','Peak Time (s)'],
                               ['',self.parent.components.SampThickInput.text,self.parent.components.DiamInput.text,self.parent.components.StrainIncInput.text,self.parent.components.NumStepsInput.text,self.parent.components.PeakTimeInput.text],
                               ['']]
            elif self.parent.testType == 'Dynamic Test':
                savestring += [['Test Parameters','Testing frequencies (Hz)','Testing Strains (%)']]
                for freq in self.parent.testfreqs:
                    savestring += [['',freq[0],freq[1]]]
                savestring += [['']]
            elif self.parent.testType == 'Combined Test':
                savestring += [['Creep Test Parameters','Start Time (s)','Load Limit (g)','Test Run Time (s)'],
                               ['',self.parent.creepTime,self.parent.components.LoadLimInput.text,self.parent.components.TimeRunInput.text],
                               ['']]
                savestring += [['SRL Test Parameters','Start Time (s)','Thickness (mm)','Diameter (mm)','Strain Incraments (%)','Number of Steps','Peak Time (s)'],
                               ['',self.parent.srlTime,self.parent.components.SampThickInput.text,self.parent.components.DiamInput.text,self.parent.components.StrainIncInput.text,self.parent.components.NumStepsInput.text,self.parent.components.PeakTimeInput.text],
                               ['']]
                savestring += [['Dynamic Test Parameters','Start Time (s)','Testing frequencies (Hz)','Testing Strains (%)']]
                if len(self.parent.testfreqs) > 0:
                    gFreqsList = []                
                    youngModulus = self.calculateYoungsModulous()
                    gFreqsValues = self.calculateGModulous()
                    savestring += [['',self.parent.dynamicTime,(self.parent.testfreqs[0])[0],(self.parent.testfreqs[0])[1]]]
                    for freq in range(1,len(self.parent.testfreqs)):
                        savestring += [['','',(self.parent.testfreqs[freq])[0],(self.parent.testfreqs[freq])[1]]]
                    for freq in range(0,len(self.parent.testfreqs)):
                        gFreqsString = 'G* at %.3fHZ' %((self.parent.testfreqs[freq])[0])
                        gFreqsList.append(gFreqsString)
                    savestring += [[''],[''],['']]
                    savestring += [['Calculated Properties','Ey'] + gFreqsList + ['Peak Load','Delta Thickness']]
                    #need to add peakLoad and deltaThickness variables to the main MechTest file
                    #peakLoad = max(all load values)
                    #deltaThickness = (final SRL position) - (initial creep position)
                    savestring += [['',youngModulus] + gFreqsValues + [self.parent.peakLoad,self.parent.deltaThickness]]
                else:
                    savestring += [[''],[''],[''],['Calculated Properties','Ey']]
                    savestring += [['',youngModulus]]
                   
            savestring += [[''],[''],[''],['Data','Time','Load','Position']]
            for data in self.parent.maindata:
                    savestring += [['',data[0],data[1],data[2]]]
            self.parent.datahan.data_save(savestring, savefile)
        else:
            dialog.messageDialog(self, 'There is no data to save as no test has been run.', 'Warning',wx.ICON_EXCLAMATION | wx.CANCEL)
        self.close()
        
    def calculateYoungsModulous(self):
        #Ey = (Lsrl-Lcrp)/(sampleArea*SRLStrain)
        sampleArea = math.pi*pow(float(self.parent.components.DiamInput.text)/2000.0,2)
        youngModulus = (self.parent.loadSRL-self.parent.loadCreap)/(sampleArea*self.parent.SRLStrain/100)
        return youngModulus
        
    def calculateGModulous(self, ):
        #G* = Ldyn/DynamicStrain
        gFreqsValues = []
        dynamicLoadMagnitude = []
        dynamicPositionMagnitude = []
        dynamicStrainMagnitude = []
        splitTimes = []       ## store when each dynamic test frequency ended
        
        for freq in range(0,len(self.parent.testfreqs)):
            splitTimes.append(self.parent.numberCycles/(self.parent.testfreqs[freq])[0])  ## backform how long the dynamic test lasted for a given frequency
        
        i = 0
        dataCount = 0
        loadRMS = 0.0
        posRMS = 0.0
        for cell in range(0, len(self.parent.dynamicdata)):
            if i<len(splitTimes):
                currentValue = self.parent.dynamicdata[cell]
                dynamicTime = currentValue[0] - self.parent.dynamicTime
                dynamicLoad = currentValue[1]
                dynamicPosition = currentValue[2]
                if dynamicTime >= splitTimes[i]:
                    dynamicLoadMagnitude.append(2*pow(2,0.5)*pow((loadRMS + pow(dynamicLoad,2.0))/float(dataCount),0.5))  ## some crazy taking the RMS to find the magnitude of the sin wave
                    dynamicPositionMagnitude.append(2*pow(2,0.5)*pow((posRMS + pow(dynamicPosition,2.0))/float(dataCount),0.5))
                    i += 1
                    dataCount = 0
                    loadRMS = 0.0
                    posRMS = 0.0
                    
                dataCount += 1
                loadRMS += pow(dynamicLoad,2.0)
                posRMS += pow(dynamicPosition,2.0)
##                loadFreqs[i].append(dynamicLoad)
##                posFreqs[i].append(dynamicPosition)
               
            
        print 'magnitude of dynamic load for each group: ',
        print dynamicLoadMagnitude

        print 'magnitude of dynamic position for each group: ',
        print dynamicPositionMagnitude

        for freq in range(0,len(dynamicPositionMagnitude)):  ## for each frequency you need a strain, load, and a final Gstar value
            dynamicStrainMagnitude.append(dynamicPositionMagnitude[freq]/float(self.parent.components.SampThickInput.text))
        
        for freq in range(0,len(self.parent.testfreqs)):
            gFreqsValues.append((9.81*dynamicLoadMagnitude[freq]/10000.0)/dynamicStrainMagnitude[freq])  ## this should correct the units

        return gFreqsValues
        
if __name__ == '__main__':
    app = model.Application(MyBackground)
    app.MainLoop()
