import time, pydaqtools as pdt

######################################
#######     Motor Class        #######
######################################


## The motor is controlled with:
## 		direction pin: 1 is out, 0 is in
##		pulse signal: generated by counter out, motor steps on high to low transition. Also can be generated by a digital out for fine steps.
## 		enable pin: set to low to turn the motor driver on or off
##		limit switch signals: keep the motor from slamming into the ends
class Motor(object):
    def __init__(self, daqid, motchannel, digchannel, cochannel):
        #Open outputs
        try:
            self.counterout = pdt.counter_output(daqid=daqid,channel=cochannel,dutycycle=0.5)
            print 'counter out'
        except:
            print 'no counter out'
        try:
            self.stepout = pdt.digital_output(daqid=daqid,channel=motchannel[1])  # use the digital out for doing single motor steps
            self.digout = pdt.digital_output(daqid=daqid,channel=[motchannel[0],motchannel[2]])
            self.digout.output([0,1]) # [in direction set, motor disabled (pin is high)]
            print 'digital out'
        except:
            print 'no digital out'
        try:
            self.digitalin = pdt.digital_input(daqid=daqid,channel=digchannel)
            print 'digital in'
        except:
            print 'no digital in'
            
    def chek_limit(self):  ## the limit switch states are in an array [front, back].  a 1 indicates it is tripped
        trip = False
        tripped = self.digitalin.get()  ## get the digital pin states, returns an array [front,back]
        if tripped[0] or tripped[1]  == 1:  	## if either is tripped, raise trip flag
            trip = True
        #[frontlim,backlim], boolean
        return tripped, trip
    
    def run_back(self, frequency):   ## this pulses the motor backwards until a limit switch trip occurs and then stops
        self.digout.output([0,0]) 
        limit = self.digitalin.get()
        self.counterout.start()
        self.counterout.update_pwm(frequency,0.5)
        while not limit[1]:
            print 'go back'
            time.sleep(0.05)
            limit = self.digitalin.get()
        self.counterout.stop()
        print 'done'
        self.disable_motor()
    
    def coarse_step(self, frequency, direction):
        #coarse running
        self.digout.output([direction,0])  #set pins to [direction,motor enabled] the direction bit with the desired direction. In = 0, out = 1
        #change pwm speed
        self.counterout.update_pwm(frequency,0.5)  #start the counter with a 50% duty cycle on the PWM signal
        #stop it

    def creep_motor(self, frequency, direction):
        self.counterout.start()
        self.counterout.update_pwm(frequency,0.5) #update the counter with a 50% duty cycle on the PWM signal
        self.digout.output([direction,0])  # 

    def creep_motor_speed(self, frequency):
        if frequency <1 :
            frequency =1
        
        self.counterout.update_pwm(frequency,0.5)  #update the counter with a 50% duty cycle on the PWM signal
        
    def set_direction(self,direction):
        self.digout.output([direction,0]) ##set pins to [direction,motor enabled] the direction bit with the desired direction. In = 0, out = 1
        
    def disable_motor(self):
        self.digout.output([0,1])  ##set pins to [direction in,motor disabled]. in = 0, out =1

    def kill_motor(self):
        self.digout.output([0,1]) ##set pins to [direction in,motor disabled]. in = 0, out =1
        try:
            self.counterout.stop()  # stop the motor pulse generator (try statement because it may be unstoppable)
        except:
            pass
        print 'motor killed'

    def creep_begin(self):  # start the pulse generation
        self.counterout.start() 
        
    def creep_end(self):   # stop the pulse generation
        self.counterout.stop()
        
    def enable_motor(self):   ##set pins to [direction in,motor enabled]. in = 0, out =1
        self.digout.output([0,0])
        
    def fine_step(self, steps, direction):  # method for fine stepping motor by using a digital out going high and low rather than a pwm signal.  More control 
        self.enable_motor()
        self.counterout.stop()
        #single stepping
        state = 0
        for x in xrange(steps*2):
            #flip-flop output for stepping
            if state == 0:
                state = 1
            elif state == 1:
                state = 0
            self.stepout.output([direction,state,0])
