import csv, time, pydaqtools as pdt

###############################################
#######     User Deinfed Options        #######
###############################################
#Channels
#anchannel =[0,1]    #[loadcell,lvdt]

#Sampling
#samprate = 1000             #rate to burst sample
#sampwait = 1.0/samprate     #time between samples
#sampnum = 10                #samples to read in
#rsediffs = 'diff'           #measure inputs in differential mode
#contfins ='fin'             #take continuous measurements

#conversions
#gramload = 250.0            #load cell rating
#voltmm = 3.0                #conversion volt to mm, calibration tool


#####################################
#######     Data Class        #######
#####################################

class Data(object):
    def __init__(self, daqid, anchannel, samprate, gramvolt, voltmm):
        #Open inputs
        self.sampwait = 1.0/samprate
        self.gramvolt = gramvolt/5.0
        self.voltmm = voltmm  #this variable controls the conversion of a voltage to an actual position
        self.poszero = 0.0
        self.loadzero = 0.0
        
        try:
            self.analogin = pdt.analog_input(daqid=daqid,channel=anchannel,contfin='fin',rsediff='diff',samplerate=samprate)
            print 'analog in'
        except:
            print 'no analog in'
            
    def update_voltmm(self, voltmm):
        self.voltmm = voltmm
        
    def acquire_data(self, sampnum, starttime):
        inputdata = []
        #get intial time for 1st data sample
        acquiretime = time.time() - starttime
        #get analog data
        acquire = self.analogin.acquire(sampnum)
        for count in xrange(sampnum):
            #[time, load, lvdt]
            inputdata.append([acquiretime+count*self.sampwait,(self.gramvolt*float(acquire[count:count+1])) - self.loadzero,(self.voltmm*float(acquire[sampnum+count:sampnum+count+1])) - self.poszero])   
        #[[time, load, lvdt],[time, load, lvdt],[time, load, lvdt],....[time, load, lvdt]]
        return inputdata
    
    def tare_load(self):
        # handles the zero load buttons in the GUI
        self.loadzero = self.gramvolt*float(sum((self.analogin.acquire(10))[:10])/10.0)
        return self.loadzero
    
    def tare_position(self):
        # handles the zero position buttons in the GUI
        self.poszero = self.voltmm*float(sum((self.analogin.acquire(10))[10:])/10.0)
        return self.poszero
    
    def data_save(self, dataout, datafilename):
        datafileobj = open(datafilename, 'wb')
        datafile = csv.writer(datafileobj, dialect='excel')
        #wite rows of data using CSV creator
        datafile.writerows(dataout)
        #close file
        datafileobj.close()
