package com.evil.audiwifi.evil;

import android.os.Bundle;
import android.app.Activity;
import android.view.Menu;


import android.app.Activity;
import android.widget.LinearLayout;
import android.os.Bundle;
import android.os.Environment;
import android.view.ViewGroup;
import android.widget.Button;
import android.view.View;
import android.view.View.OnClickListener;
import android.content.Context;
import android.util.Log;
import android.media.MediaRecorder;
import android.media.MediaPlayer;
import java.io.IOException;
public class MainActivity extends Activity
{    private static final String LOG_TAG = "evil";    
private static String mFileName = null;    
private RecordButton mRecordButton = null;    
private MediaRecorder mRecorder = null;    
private PlayButton   mPlayButton = null;    
private MediaPlayer   mPlayer = null;    
private void onRecord(boolean start) {        
	if (start) {            
		startRecording();        
		} else {            
			stopRecording();        
			}    
	}    
private void onPlay(boolean start) {        
	if (start) {            
		startPlaying();        
		} else {            
			stopPlaying();        
			}    
	}    
private void startPlaying() {        
	mPlayer = new MediaPlayer();        
	try {            
		mPlayer.setDataSource(mFileName);            
		mPlayer.prepare();            
		mPlayer.start();        } 
	catch (IOException e) {            
		Log.e(LOG_TAG, "prepare() failed");        
		}    }    private void stopPlaying() {        
			mPlayer.release();        
			mPlayer = null;    }    
		public MainActivity() {        
			mFileName = Environment.getExternalStorageDirectory().getAbsolutePath();        
			mFileName += "/audiorecordtest.3gp";    
			}    
		private void startRecording() {        
			mRecorder = new MediaRecorder();        
			mRecorder.setAudioSource(MediaRecorder.AudioSource.MIC);        
			mRecorder.setOutputFormat(MediaRecorder.OutputFormat.THREE_GPP);        
			mRecorder.setAudioEncoder(MediaRecorder.AudioEncoder.AMR_NB);
			mRecorder.setOutputFile(mFileName);
			mFileName = Environment.getExternalStorageDirectory().getAbsolutePath();        
			mFileName += "/audiorecordtest.3gp";  
			try {            mRecorder.prepare();        
			} catch (IOException e) {            
				Log.e(LOG_TAG, "prepare() failed");        
				}        mRecorder.start();    }    
		private void stopRecording() {        
			mRecorder.stop();
			/***/mRecorder.reset();
			mRecorder.release();        
			mRecorder = null;    }    
		class RecordButton extends Button {        
			boolean mStartRecording = true;        
			OnClickListener clicker = new OnClickListener() {            
				public void onClick(View v) {                
					onRecord(mStartRecording);                
					if (mStartRecording) {                    
						setText("Stop recording");                
						} else {                    
							setText("Start recording");                
							}                
					mStartRecording = !mStartRecording;            
					}        
				};        
				public RecordButton(Context ctx) {            
					super(ctx);            
					setText("Start recording");            
					setOnClickListener(clicker);        
					}    
				}    
		class PlayButton extends Button {        
			boolean mStartPlaying = true;        
			OnClickListener clicker = new OnClickListener() {            
				public void onClick(View v) {                
					onPlay(mStartPlaying);                
					if (mStartPlaying) {                    
						setText("Stop playing");                
						} else {                    
							setText("Start playing");                
							}                
					mStartPlaying = !mStartPlaying;            
					}        
				};        
				public PlayButton(Context ctx) {            
					super(ctx);            
					setText("Start playing");            
					setOnClickListener(clicker);        
					}    
				}    
		
		@Override    
		public void onCreate(Bundle icicle) {        
			super.onCreate(icicle);        
			LinearLayout ll = new LinearLayout(this);        
			mRecordButton = new RecordButton(this);        
			ll.addView(mRecordButton,            
					new LinearLayout.LayoutParams(                
							ViewGroup.LayoutParams.WRAP_CONTENT,                
							ViewGroup.LayoutParams.WRAP_CONTENT,                
							0));        
			mPlayButton = new PlayButton(this);        
							ll.addView(mPlayButton,            
									new LinearLayout.LayoutParams(                
											ViewGroup.LayoutParams.WRAP_CONTENT,                
											ViewGroup.LayoutParams.WRAP_CONTENT,                
											0));        
							setContentView(ll);    }    
		@Override    
		public void onPause() 
		{        
			super.onPause();        
			if (mRecorder != null) {            
				mRecorder.release();            
				mRecorder = null;        
				}        
			if (mPlayer != null) {            
				mPlayer.release();            
				mPlayer = null;        
				}    
			
		}}