package com.yoyobro.firstapp;

import java.io.IOException;
//import java.util.Calendar;

import android.app.Activity;
import android.media.MediaRecorder;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.widget.Button;

public class MainActivity extends Activity {
		/** Called when the activity is first created. */
		private MediaRecorder mediaRecorder;
		private static String mFileName = null;
		boolean recording= false;
		private Button start; //Start Button to start the recordings
		private Button stop; // Stop button to stop the recordings
		@Override
		public void onCreate(Bundle savedInstanceState) 
		{
		    super.onCreate(savedInstanceState);
		    setContentView(R.layout.activity_main);
		    mediaRecorder = new MediaRecorder();
		    start = (Button)findViewById(R.id.start);

		    //Activity when user click the start Button
		    start.setOnClickListener(new View.OnClickListener() {

		        public void onClick(View v) {
		            // TODO Auto-generated method stub
		            settings();
		            recordPrepare();
		            mediaRecorder.start();
		            recording = true;

		        }

		    });

		    //Activity when user click the stop Button
		    stop = (Button)findViewById(R.id.stop);
		    stop.setOnClickListener(new View.OnClickListener() {

		        public void onClick(View v) {
		            // TODO Auto-generated method stub

		            if(recording)
		            {
		                mediaRecorder.stop();
		                mediaRecorder.release();
		                recording = false;
		                settings();
		                recordPrepare();
		            }

		        }
		    });
		}
		//Settings for Audio Recorder
		private void settings()
		{
		    //long name = new Date().getTime();
		    mediaRecorder.setAudioSource(MediaRecorder.AudioSource.MIC);
		    //mediaRecorder.setOutputFormat(MediaRecorder.OutputFormat.DEFAULT);
		    mediaRecorder.setOutputFormat(MediaRecorder.OutputFormat.THREE_GPP);
		    mediaRecorder.setAudioEncoder(MediaRecorder.AudioEncoder.DEFAULT);
		    mFileName = Environment.getExternalStorageDirectory().getAbsolutePath();
		    mFileName += "/youraudiofile.3gp";
		   // mediaRecorder.setOutputFile("youraudiofile.3gp");
		    mediaRecorder.setOutputFile(mFileName);
		   // mediaRecorder.setOutputFile("/sdcard/"+Long.toString(name)+".3gp");
		   // DataModel dbModel = new DataModel(this);
		    //Calendar cal = Calendar.getInstance();
		    //dbModel.insertMultimedia("/sdcard/"+Long.toString(name)+".3gp", Long.toString(name), cal);
		}
		//prepare the Environment for Recording
		private void recordPrepare()
		{
		    try
		    {
		        mediaRecorder.prepare();
		    }
		    catch(IllegalStateException e)
		    {
		        e.printStackTrace();

		    } 
		    catch (IOException e) 
		    {
		        e.printStackTrace();
		    }
		}
}