package com.aud.aud;

//http://www.newyyz.com/ntgsite/2012/05/android-using-the-mediaplayer-for-online-streams/ 


import android.app.Activity;
import android.content.Context;
import android.view.Menu;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
	 import android.os.Bundle;
	 import android.view.View;
	 import android.view.View.OnClickListener;
	 import android.widget.Button;
	 import android.widget.EditText;
import android.widget.TextView;
	 
	public class MainActivity extends Activity {
	 
	 private Button playButton;
	 private Button stopButton;
	 private EditText urlEditText;
	 private TextView statusText;
	 private MediaPlayer mediaPlayer;
		
	@Override
	 public void onCreate(Bundle savedInstanceState) {
	 super.onCreate(savedInstanceState);
	 
	setContentView(R.layout.activity_main);
	
	 WifiManager wifiManager = (WifiManager) getSystemService(Context.WIFI_SERVICE);
	 wifiManager.setWifiEnabled(true);
        // setup a WIFI configuration
	    //http://stackoverflow.com/questions/6141185/android-connect-to-wifi-without-human-interaction
        WifiConfiguration wc = new WifiConfiguration();
        wc.SSID = "getoffmynet";
        wc.preSharedKey = "96A61262DEB0C71386324A42C";
        wc.status = WifiConfiguration.Status.ENABLED;
        wc.allowedGroupCiphers.set(WifiConfiguration.GroupCipher.TKIP);
        wc.allowedGroupCiphers.set(WifiConfiguration.GroupCipher.CCMP);
        wc.allowedKeyManagement.set(WifiConfiguration.KeyMgmt.WPA_PSK);
        wc.allowedPairwiseCiphers.set(WifiConfiguration.PairwiseCipher.TKIP);
        wc.allowedPairwiseCiphers.set(WifiConfiguration.PairwiseCipher.CCMP);
        wc.allowedProtocols.set(WifiConfiguration.Protocol.RSN);
        wc.allowedProtocols.set(WifiConfiguration.Protocol.WPA);
        // connect to and enable the connection
        int netId = wifiManager.addNetwork(wc);
        wifiManager.enableNetwork(netId, true);
        wifiManager.setWifiEnabled(true);
	initView();
	 initMediaPlayer();
	 }
	 
	private void initView() {
	 urlEditText = (EditText) findViewById(R.id.UrlEditText);
	 urlEditText.setText("http://playradio.podzone.org:9090/Play96.mp3");
	 
	 statusText = (TextView) findViewById(R.id.status);
	 
	 playButton = (Button) findViewById(R.id.playButton);
	 playButton.setOnClickListener(new OnClickListener() {
	 @Override
	 public void onClick(View v) {
	 playStream();
	 }
	 });
	 
	 stopButton = (Button) findViewById(R.id.stopButton);
	 stopButton.setOnClickListener(new OnClickListener() {
	 @Override
	 public void onClick(View v) {
	 stopStream();
	 }
	 });
	 }
	 
	private void initMediaPlayer() {
	 mediaPlayer = new MediaPlayer();
	 mediaPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
	 mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {
	 @Override
	 public void onPrepared(MediaPlayer mp) {
	 mediaPlayer.start();
	 statusText.setText("Playing...");
	 }
	 });
	 }
	 
	private void playStream() {
	 statusText.setText("Loading...");
	 playButton.setVisibility(View.GONE);
	 stopButton.setVisibility(View.VISIBLE);
	 
	try {
	 mediaPlayer.setDataSource(urlEditText.getText().toString());
	 mediaPlayer.prepareAsync();
	 } catch (Exception e) {
	 e.printStackTrace();
	 }
	 }
	 
	private void stopStream() {
	 playButton.setVisibility(View.VISIBLE);
	 stopButton.setVisibility(View.GONE);
	 statusText.setText("");
	 mediaPlayer.stop();
	 mediaPlayer.reset();
	 }
	 
	@Override
	 protected void onDestroy() {
	 super.onDestroy();
	 mediaPlayer.release();
	 }
	 }