import pydaqtools as pdt
import csv, math, numpy, time

def collectdata(seconds,date,testnumber,filename,samplerate,bestfreq,daq):
    savefilename= (filename+ '.csv')
    savestring= [[date, testnumber]]
    savestring+=[['time stamp','load']]
    datalist = list()
    timelist = list()
    finaltimes = list()
    datastring=list()
    datafileobj = open(savefilename, 'wb')
    datafile = csv.writer(datafileobj, dialect='excel')
    #Collection of data here:
    zerotime = time.clock()
    for i in range(0,int(seconds)):
        timelist.append(time.clock()-zerotime)
        datalist +=list(daq.acquire(bestfreq))
    #Ends collecting data,starts saving data
    for t in timelist:
        try:
            for a in t:
                for i in range(bestfreq):
                    finaltimes.append(float(a)+float(i)/float(samplerate))
        except:
            for i in range(bestfreq):
                finaltimes.append(float(t)+float(i)/float(samplerate))
    length=0
    for x in datalist:
        for i in x:
            try:
                for c in i:
                    datastring.append(c)
                    length=length+1
            except: 
                datastring.append(i)
                length=length+1
    for i in range(length):
        savestring += [[finaltimes[i],datastring[i]]]
    #Writing the actual data onto the csv file
    datafile.writerows(savestring)
    datafileobj.close()
