import pydaqtools as pdt
import csv, math, numpy, time

#G01 Linear Paths
#G54 Sets the zeroes of the CNC machine
#G90 Absolute movement
#G21 Units are in millimeters

#This is the Dynamic Test Generator function with Linear Approximation
def dyngenlin(oscillations, frequency, amplitude, incrementsPerCycle, filename, date,startvalue):
    feedrate=4.0*float(amplitude)*float(frequency)*60.0
    startlocation=startvalue #the program should find the Z coordinate of the CNC machine here if we find a way to actively communicate with the CNC
    sinwavevalues=[] #creates an array that holds the location values
    coswavevalues=[(feedrate)] #creates an array that holds the feedrate values
    fileoutput=['N100 G01 G54 G90 G21'] #fileoutput is an array that contains the G code.
                            #N*** indicates line number, G54 is the set of coordinates, G01 creates linear tool paths,
                            #G90 makes the movement absolute (meaning based around 0), and G21 means mm
                            #the G code format is Nxxx Z**.**** F&&.&&&&, where xxx is the step number, Z is the axis, **.**** is decimal indicating the location
                            #of the machining tool, F indicates feed rate, &&.&&&& is the desired feedrate
    time=0
    for j in range(oscillations):
        sinwavevalues.append(startlocation)
        for i in range(1,incrementsPerCycle):
                #adds a location to the sinwavevalue array and the feedrate string to the coswavevalue array
                sinwavevalues.append(round((startlocation+amplitude*math.sin(2*math.pi*(float(i)/float(incrementsPerCycle)))),4))
    for i in range(1, len(sinwavevalues)):
        try:
            #This does a linear approximation of a cosine wave
            coswavevalues.append(abs((sinwavevalues[i]-sinwavevalues[i-1])*frequency*incrementsPerCycle*float(60)))
            #This part measures the time it takes to go through this G-code
            time=time+abs(abs(sinwavevalues[i]-sinwavevalues[i-1])/abs(coswavevalues[i]))*float(60.0)
        except:
            #The try catch statement catches the case where the cosine is zero
            time=time
    for i in range(len(sinwavevalues)):
        #creates the formatting for the file output array
        fileoutput.append('N'+str(101+i)+' Z'+str(sinwavevalues[i])+' F'+str(coswavevalues[i]))

    #Here begins the data saving part
    savefilename=(filename+'.nc')
    savestring=[["("+date+")"],["(Dynamic Test)"],["(Oscillations: "+str(oscillations)+")"],["(Frequency: "+str(frequency)+"Hz)"],["(Amplitude: "+str(amplitude)+"mm)"],["(Total Time: "+str(time)+"s)"],[" "]]
    for d in fileoutput:
        savestring +=[[d]]
    datafileobj = open(savefilename, 'wb')
    datafile = csv.writer(datafileobj)
    datafile.writerows(savestring)
    datafileobj.close()

    print " "
    print "The G-Code has been created"

def dyngencos(oscillations, frequency, amplitude, incrementsPerCycle, filename, date,startvalue):
    feedrate=4*amplitude*frequency*60
    acceptable=10
    startlocation=startvalue #the program should find the Z coordinate of the CNC machine here if we find a way to actively communicate with the CNC
    sinwavevalues=[] #creates an array that holds the location values
    coswavevalues=[(feedrate)] #creates an array that holds the feedrate values
    fileoutput=['N100 G01 G54 G90 G21'] #fileoutput is an array that contains the G code.
                            #N*** indicates line number, G54 is the set of coordinates, G01 creates linear tool paths,
                            #G90 makes the movement absolute (meaning based around 0), and G21 means mm
                            #the G code format is Nxxx Z**.**** F&&.&&&&, where xxx is the step number, Z is the axis, **.**** is decimal indicating the location
                            #of the machining tool, F indicates feed rate, &&.&&&& is the desired feedrate    
    time=0
    for j in range(oscillations):
        sinwavevalues.append(startlocation)
        for i in range(1,incrementsPerCycle):
                #adds a location to the sinwavevalue array and the feedrate string to the coswavevalue array
                sinwavevalues.append(round((startlocation+amplitude*math.sin(2*math.pi*(float(i)/float(incrementsPerCycle)))),4))
    for i in range(1, len(sinwavevalues)):
        try:
            #This creates an actual cosine wave
            coswavevalues.append((abs(round((feedrate*math.cos(2*math.pi*(float(i)/float(incrementsPerCycle)))),4))))
            #This part measures the time it takes to go through this G-code
            time=time+abs(abs(sinwavevalues[i]-sinwavevalues[i-1])/abs(coswavevalues[i]))*float(60.0)
        except:
            #The try catch statement catches the case where the cosine is zero
            time=time
    for i in range(len(sinwavevalues)):
        #creates the formatting for the file output array
        fileoutput.append('N'+str(101+i)+' Z'+str(sinwavevalues[i])+' F'+str(coswavevalues[i]))


    #Here begins the data saving part
    savefilename=(filename+'.nc')
    savestring=[["("+date+")"],["(Dynamic Test)"],["(Oscillations: "+str(oscillations)+")"],["(Frequency: "+str(frequency)+"Hz)"],["(Amplitude: "+str(amplitude)+"mm)"],["(Total Time: "+str(time)+"s)"],[" "]]
    for d in fileoutput:
        savestring +=[[d]]
    datafileobj = open(savefilename, 'wb')
    datafile = csv.writer(datafileobj)
    datafile.writerows(savestring)
    datafileobj.close()

    print " "
    print "The G-Code has been created"

def dyngenlinsaver(oscillations, frequency, amplitude, incrementsPerCycle, startvalue):
    feedrate=4.0*float(amplitude)*float(frequency)*60.0
    startlocation=startvalue #the program should find the Z coordinate of the CNC machine here if we find a way to actively communicate with the CNC
    sinwavevalues=[] #creates an array that holds the location values
    coswavevalues=[(feedrate)] #creates an array that holds the feedrate values
    #fileoutput=['N100 G01 G54 G90 G21'] #fileoutput is an array that contains the G code.
                            #N*** indicates line number, G54 is the set of coordinates, G01 creates linear tool paths,
                            #G90 makes the movement absolute (meaning based around 0), and G21 means mm
                            #the G code format is Nxxx Z**.**** F&&.&&&&, where xxx is the step number, Z is the axis, **.**** is decimal indicating the location
                            #of the machining tool, F indicates feed rate, &&.&&&& is the desired feedrate
    time=0
    for j in range(oscillations):
        sinwavevalues.append(startlocation)
        for i in range(1,incrementsPerCycle):
                #adds a location to the sinwavevalue array and the feedrate string to the coswavevalue array
                sinwavevalues.append(round((startlocation+amplitude*math.sin(2*math.pi*(float(i)/float(incrementsPerCycle)))),4))
    for i in range(1, len(sinwavevalues)):
        try:
            #This does a linear approximation of a cosine wave
            coswavevalues.append(abs((sinwavevalues[i]-sinwavevalues[i-1])*frequency*incrementsPerCycle*float(60)))
            #This part measures the time it takes to go through this G-code
            time=time+abs(abs(sinwavevalues[i]-sinwavevalues[i-1])/abs(coswavevalues[i]))*float(60.0)
        except:
            #The try catch statement catches the case where the cosine is zero
            time=time
    fileoutput=[]
    for i in range(len(sinwavevalues)):
        #creates the formatting for the file output array
        fileoutput.append('Z'+str(sinwavevalues[i])+' F'+str(coswavevalues[i]))
        
    savestring=[]
    #Here begins the data saving part
    for d in fileoutput:
        savestring +=[[d]]

    return [savestring,time]
