import csv

def SRLTestGenerator(thickness, increments, peaktime, steps, date, filename):
    if (increments*steps>100):
        print " "
        print "That is impossible. Please try again."
        print " "
        print " "
        print " "
        print " "
        print " "
    else:
        feedrate=3000.0
        fileoutput=['N100 G01 G54 G90 G21 F'+str(feedrate)]
        for i in range(int(steps)) :
           fileoutput.append('N'+str(101+2*i)+' Z'+str(round(-1.0000*float(i+1)*thickness*increments/100.0000,4)))
           fileoutput.append('N'+str(102+2*i)+' G04 P'+str(peaktime*1000))
        savefilename=(filename+'.nc')
        savestring=[["("+date+")"],["(SRL Test)"],["(Thickness of Sample="+str(thickness)+")"],["(Increments="+str(increments)+")"],["(Peak Time="+str(peaktime)+")"],["(Number of Steps="+str(steps)+")"],[" "]]
        for d in fileoutput:
            savestring +=[[d]]
        datafileobj = open(savefilename, 'wb')
        datafile = csv.writer(datafileobj)
        datafile.writerows(savestring)
        datafileobj.close()

        print " "
        print "The G-Code for the SRL Test has been created"

def SRLTestsaver(thickness, increments, peaktime, steps):
    #for combined test
    if (increments*steps>100):
        print " "
        print "That is impossible. Please try again."
        print " "
        print " "
        print " "
        print " "
        print " "
    else:
        fileoutput=[]
        for i in range(int(steps)) :
            lastposition=str(round(-1.0000*float(i+1)*thickness*increments/100.0000,4))
            fileoutput.append('Z'+str(round(-1.0000*float(i+1)*thickness*increments/100.0000,4)))
            fileoutput.append('G04 P'+str(peaktime*1000))
        savestring=[]
        for d in fileoutput:
            savestring +=[[d]]
        return [savestring,lastposition]
