#!/usr/bin/python

"""
__version__ = "$Revision: 1.5 $"
__date__ = "$Date: 2004/04/30 16:26:12 $"
"""

from PythonCard import model
import dynamictests, daqcalibr, daqfinder,collector, SRLtest
import pydaqtools as pdt
import csv, math, numpy, time

class MyBackground(model.Background):

    def on_initialize(self, event):
        # if you have any initialization
        # including sizer setup, do it here
        print 'Please wait one moment while we search for the DAQs connected to your computer'
        daqfinder.findDaq()

    def on_findDaq_mouseClick(self,event):
        daqfinder.findDaq()
        print 'Choose the appropriate DAQ'

    def on_connectMeToThisDaq_mouseClick(self,event):
        try:
            global daqinformation
            daqinformation=daqfinder.connector(int(self.components.daqidfield.text),int(self.components.daqchannelfield.text),int(self.components.sampleratefield.text))
            self.components.connectedToADaq.checked=True
            #This needs to change. When attempting to connect to a nonexistent DAQ,
            #pdt.daqfind() outputs something instead of throwing up an error
        except:
            print 'Please input valid numbers or try finding your DAQs again'
            self.components.connectedToADaq.checked=False
        
    def on_showMeTheDaqInfo_mouseClick(self,event):
        try:
            daqfinder.showdaqinfo(int(self.components.daqidfield.text))
        except:
            print 'Please input a valid DAQ ID or try finding your DAQs again'

    def on_generateSrlTest_mouseClick(self,event):
        try:
            SRLtest.SRLTestGenerator(int(self.components.Thickness.text),int(self.components.Percentage.text),int(self.components.PeakTime.text),int(self.components.Steps.text),self.components.date.text,self.components.Filename.text)
        except:
            print 'Please input valid numbers'

    def on_Calibrate_mouseClick(self,event):
        try:
            self.components.idealsamprate.text=str(daqcalibr.calibrate(daqinformation[0],daqinformation[3],int(self.components.error.text)))
        except:
            print 'Try again'
            self.components.idealsamprate.text=''

    def on_generateDynamicTest_mouseClick(self,event):
        try:
            #filenamedyn, Datefield, frequencyfield, amplitudeField, Oscillationfield, Incrementfield
            dynamictests.dyngenlin(int(self.components.Oscillationfield.text),float(self.components.frequencyfield.text),float(self.components.amplitudeField.text),int(self.components.Incrementfield.text),self.components.filenamedyn.text,self.components.Datefield.text,0)
        except:
            print 'Please input valid numbers'

    def on_Combinedbutton_mouseClick(self,event):
        try:
            SRLsaverarray=SRLtest.SRLTestsaver(int(self.components.Thickness.text),int(self.components.Percentage.text),int(self.components.PeakTime.text),int(self.components.Steps.text))
            #SRLsaverarray stores the string output from the SRL test and 
            dyngenlinsaverarray=dynamictests.dyngenlinsaver(int(self.components.Oscillationfield.text),float(self.components.frequencyfield.text),float(self.components.amplitudeField.text),int(self.components.Incrementfield.text),float(SRLsaverarray[1]))
            savefilename=self.components.Filename.text+self.components.filenamedyn.text+'.nc'
            savestring=[["("+self.components.date.text+")"],["(SRL Test)"],["(Thickness of Sample="+str(int(self.components.Thickness.text))+")"],["(Increments="+str(int(self.components.Percentage.text))+")"],["(Peak Time="+str(int(self.components.PeakTime.text))+")"],["(Number of Steps="+str(int(self.components.Steps.text))+")"],[" "]]
            savestring+=[["("+self.components.Datefield.text+")"],["(Dynamic Test)"],["(Oscillations: "+str(int(self.components.Oscillationfield.text))+")"],["(Frequency: "+str(float(self.components.frequencyfield.text))+"Hz)"],["(Amplitude: "+str(float(self.components.amplitudeField.text))+"mm)"],[" "]]
            totaltime=dyngenlinsaverarray[1]
            savestring+=[['(Total time: ' +str(totaltime)+'s)']]
            i=1
            savestring+=[["N100 G01 G54 G90 G21 F3000.0"]]
            for d in SRLsaverarray[0]:
                savestring+=[['N'+str(100+i)+' '+d[0]]]
                i=i+1
            for d in dyngenlinsaverarray[0]:
                savestring+=[['N'+str(100+i)+' '+d[0]]]
                i=i+1
            datafileobj = open(savefilename, 'wb')
            datafile = csv.writer(datafileobj)
            datafile.writerows(savestring)
            datafileobj.close()
            print 'The G-Code has been created. Look at ' +savefilename
        except:
            print 'Please input valid numbers'

    def on_collectData_mouseClick(self,event):
        try:
            #filenamecollector
            #datecollector
            #testnumber
            #seconds
            print 'The Data Acquisition has begun. You are now locked out of the GUI interface.'
            collector.collectdata(int(self.components.seconds.text),self.components.datecollector.text,self.components.testnumber.text,self.components.filenamecollector.text,daqinformation[3],int(self.components.idealsamprate.text),daqinformation[0])
            print 'The Data has been collected. Please look in '+self.components.filenamecollector.text+'.csv'
        except:
            print 'Collection failed. Please input valid numbers or connect to your DAQ again'
    def on_ImageButton1_mouseClick(self,event):
        try:
            print 'Image Button will include a quick description of Calibration.'
        except:
            print 'Failure'
if __name__ == '__main__':
    app = model.Application(MyBackground)
    app.MainLoop()
