import pydaqtools as pdt
import csv, math, numpy, time

#This is the Dynamic Test Generator function with Linear Approximation
def dyngenlin(oscillations, frequency, amplitude, incrementsPerCycle, filename, date):
    feedrate=4*amplitude*frequency*60 
    sinwavevalues=[0] #creates an array that holds the location values
    coswavevalues=[(feedrate)] #creates an array that holds the feedrate values
    fileoutput=['N100 G01 G54 G90 G21'] #fileoutput is an array that contains the G code.
                            #N*** indicates line number, G54 is the set of coordinates, G01 creates linear tool paths,
                            #G90 makes the movement absolute (meaning based around 0), and G21 means mm
                            #the G code format is Nxxx Z**.**** F&&.&&&&, where xxx is the step number, Z is the axis, **.**** is decimal indicating the location
                            #of the machining tool, F indicates feed rate, &&.&&&& is the desired feedrate

    startlocation=0 #the program should find the Z coordinate of the CNC machine here if we find a way to actively communicate with the CNC

    for i in range(samplenum*oscillations):
        #adds a location string to the sinwavevalue array and the feedrate string to the coswavevalue array
        sinwavevalues.append((round((startlocation+amplitude*math.sin(2*math.pi*(float(i+1)/float(samplenum))*frequency)),4)))
        #coswavevalues.append((abs(round((feedrate*math.cos(2*math.pi*(float(i+1)/float(samplenum))*frequency)),4))))
        
        #checks for any 0 feedrates and replaces them with the previous value for the feedrate
        if (i==0):
            coswavevalues[i]=feedrate
        else:
            #This does a linear approximation of a cosine wave
            coswavevalues[i]=abs((sinwavevalues[i]-sinwavevalues[i-1])*frequency/samplenum*60)
        #creates the formatting for the file output array
        fileoutput.append('N'+str(101+i)+' Z'+str(sinwavevalues[i])+' F'+str(coswavevalues[i]))

    #Here begins the data saving part
    savefilename=(filename+'.nc')
    savestring=[["("+date+")"],["(Dynamic Test)"],["(Oscillations: "+str(oscillations)+")"],["(Frequency: "+str(frequency)+"Hz)"],["(Amplitude: "+str(amplitude)+"mm)"],["(Maximum Feed Rate: "+str(feedrate)+"mm/min)"],[" "]]
    for d in fileoutput:
        savestring +=[[d]]
    datafileobj = open(savefilename, 'wb')
    datafile = csv.writer(datafileobj)
    datafile.writerows(savestring)
    datafileobj.close()

    print " "
    print "The G-Code has been created"

def dyngencos(oscillations, frequency, amplitude, incrementsPerCycle, filename, date):
    feedrate=4*amplitude*frequency*60
    acceptable=10
    sinwavevalues=[0] #creates an array that holds the location values
    coswavevalues=[(feedrate)] #creates an array that holds the feedrate values
    fileoutput=['N100 G01 G54 G90 G21'] #fileoutput is an array that contains the G code.
                            #N*** indicates line number, G54 is the set of coordinates, G01 creates linear tool paths,
                            #G90 makes the movement absolute (meaning based around 0), and G21 means mm
                            #the G code format is Nxxx Z**.**** F&&.&&&&, where xxx is the step number, Z is the axis, **.**** is decimal indicating the location
                            #of the machining tool, F indicates feed rate, &&.&&&& is the desired feedrate

    startlocation=0 #the program should find the Z coordinate of the CNC machine here if we find a way to actively communicate with the CNC

    for i in range(samplenum*oscillations):
        #adds a location string to the sinwavevalue array and the feedrate string to the coswavevalue array
        sinwavevalues.append((round((startlocation+amplitude*math.sin(2*math.pi*(float(i+1)/float(samplenum))*frequency)),4)))
        coswavevalues.append((abs(round((feedrate*math.cos(2*math.pi*(float(i+1)/float(samplenum))*frequency)),4))))
        if coswavevalues[i]<=acceptable:
            coswavevalues[i]=acceptable;
        
        #checks for any 0 feedrates and replaces them with the previous value for the feedrate
##        if (i==0):
##            coswavevalues[i]=feedrate
##        else:
##            #This does a linear approximation of a cosine wave
##            coswavevalues[i]=abs((sinwavevalues[i]-sinwavevalues[i-1])*frequency/samplenum*60)
        #creates the formatting for the file output array
        fileoutput.append('N'+str(101+i)+' Z'+str(sinwavevalues[i])+' F'+str(coswavevalues[i]))

    #Here begins the data saving part
    savefilename=(filename+'.nc')
    savestring=[["("+date+")"],["(Dynamic Test)"],["(Oscillations: "+str(oscillations)+")"],["(Frequency: "+str(frequency)+"Hz)"],["(Amplitude: "+str(amplitude)+"mm)"],["(Maximum Feed Rate: "+str(feedrate)+"mm/min)"],[" "]]
    for d in fileoutput:
        savestring +=[[d]]
    datafileobj = open(savefilename, 'wb')
    datafile = csv.writer(datafileobj)
    datafile.writerows(savestring)
    datafileobj.close()

    print " "
    print "The G-Code has been created"
