import pydaqtools as pdt
import csv, math, numpy, time

#This is the DAQ calibrating function
def calibrate(ai,samplerate):
    done=False
    collectnum=samplerate
    bestfreq=samplerate
    besttimedifference=1
    changevalue=10
    errorrange=float(input('What is an acceptable error? :  '))
    toobig=True
    print 'Now calculating the best number of samples to collect per second'
    print 'Please wait...'

    while (done!=True):
        #This part gets what the error is
        zerotime=time.clock()
        ai.acquire(collectnum)
        timedifference=time.clock()-zerotime-1
        #This part checks if the error is better than the best error so far
        if abs(timedifference)<besttimedifference:
            besttimedifference=abs(timedifference)
            bestfreq=collectnum
        #This part checks if we're above or below the error
        if timedifference>errorrange:               #if we are above the error
            if toobig:                              #and we were above it before
                collectnum=collectnum-changevalue   #then bring down the number we're collecting
            else:                                   #if we were below it before and went above it
                toobig=True                         #then switch the variable to say we are now below the error
                if changevalue<1:                  #check if it's even possible to get that error...
                    done=True
                    break
                changevalue=changevalue-1           #This will reduce the amount we change in the number of samples collected
                print '...'
        elif timedifference<-1*errorrange:          #From here the program does basically the same thing again
            if toobig==False:
                collectnum=collectnum+changevalue
            else:
                toobig=False
                if changevalue<1:
                    done=True
                    break
                changevalue=changevalue-1
                print '...'
        #And if we are within an acceptable error, then it'll leave the while loop.
        else:
            done=True
    #The program then returns the best frequency we found
    return bestfreq
#function definition ends here
