import dynamictests, daqcalibr, daqfinder,collector, SRLtest
import pydaqtools as pdt
import csv, math, numpy, time

#Step 1: Find your Data Acquisition device:
daqfinder.daqfinder()

#Step 2: Calibrate your Data Acquisition Device:
bestfrequency=daqcalibr.calibrate(daqfinder.ai, daqfinder.samplrate)

#Step 3: Create an SRL Test:
    #These inputs would be replaced by the variables in the GUI
thickness=float(input("What is the initial thickness of your sample? (in mm) "))
increments=float(input("What percentage of the sample thickness would you like to extend the motor shaft per step? "))
peaktime=float(input("How long would you like to hold each step position? (in seconds) "))
steps=input("How many steps would you like to perform?")
date=raw_input("What is today's date? (Input a string) ")
filename=raw_input("What is your file name? (Input a string) ")
SRLtest.SRLTestGenerator(thickness, increments, peaktime, steps, date, filename)

###We need to merge these two tests into one G-code...
###Which should be easy since we have both savestrings available
###But for now, I'll leave the two separate

#Step 3: Create the Dynamic Test Generator:
    #These inputs would be replaced by the variables in the GUI
oscillations=input('Oscillations')
frequency=input('Frequency?')
increments=input('Increments Per Cycle?')
filename=input('Filename for the Dynamic Test?')
date=input('date')
done=False
while done==False:
    lin=raw_input('Would you like a linear approximation or a full cosine wave? (Input l/c)')
    if lin=='l' or lin=='L':
        dynamictests.dyngenlin(oscillations, frequency, increments, filename, date)
        done=True
    elif lin=='c' or lin=='C':
        dynamictests.dyngencos(oscillations, frequency, increments, filename, date)
        done=True
    else:
        print 'Oops, that is not an acceptable response'
        print 'Try again.'

#Step 4: Start Collecting data
time=input('Duration of Data Collection?')
testnumber=input('Test Number?')
filename=input('File Name for acquired data?')
collector.collectdata(time,date,testnumber,filename,daqfinder.samplrate,bestfrequency,daqfinder.ai)
